use "${tmp}/Regfile_nafZE", replace

	
	xtset gp year
	
	destring ZE2010, replace
	
	// define sample 
	egen mlabexid = group(mainlabex)
	qui su mlabexid
	replace mlabexid = r(max) + ZE2010 if mi(mlabexid)
	

	reghdfe ln_eng_sbrut E_post11  if NAF_labex_accept == 1 & ZE_labex_accept == 1 , a(ZE2010#year  gp)  cl(mlabexid)	
	bys gp: egen insampeng = max(e(sample))
	keep if insampeng
	 
	global cond_accept = "NAF_labex_accept == 1 & ZE_labex_accept == 1" 
	
	// Col 1 
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp year") clust(mlabexid) 
	local row1 = "`=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'"
	local row2 = "(`=string(e(se), "%9.4f")') & "
	
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_hrs) fe("gp year") clust(mlabexid) 
	local row3 = "`=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'"
	local row4 = "(`=string(e(se), "%9.4f")') & "
	
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_hrwg) fe("gp year") clust(mlabexid) 
	local row5 = "`=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'"
	local row6 = "(`=string(e(se), "%9.4f")') & "
	
	// Col 2
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ZE2010#year") clust(mlabexid)
	local row1 = "`row1' &  `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'"
	local row2 = "`row2' & (`=string(e(se), "%9.4f")') & "
	
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_hrs) fe("gp ZE2010#year") clust(mlabexid) 
	local row3 = "`row3' &  `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'"
	local row4 = "`row4' & (`=string(e(se), "%9.4f")') & "
	
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_hrwg) fe("gp ZE2010#year") clust(mlabexid) 
	local row5 = "`row5' &  `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'"
	local row6 = "`row6' & (`=string(e(se), "%9.4f")') & "
	
	// Col 3
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ape_n##year ZE2010#year") clust(mlabexid) 
	local row1 = "`row1' & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
	local row2 = "`row2' & (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_hrs) fe("gp ape_n##year ZE2010#year") clust(mlabexid) 
	local row3 = "`row3' & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
	local row4 = "`row4' &  (`=string(e(se), "%9.4f")') &  & (`=e(Npairs)' pairs) \\ "
	
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_hrwg) fe("gp ape_n##year ZE2010#year") clust(mlabexid) 
	local row5 = "`row5' & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'  & `=e(Nobs)' obs \\"
	local row6 = "`row6' &  (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	
	local row0 = "Estimate & Pre-trends test & Estimate & Pre-trends test & Estimate & Pre-trends test & Obs \\"
	disp in red " ********************** TABLE 2 **********************"
	disp in red "`row1'"
	disp in red "`row2'"
	disp in red "`row3'"
	disp in red "`row4'"
	disp in red "`row5'"
	disp in red "`row6'"	
	
	file open myfile using "${outpath}/table2.tex", write text replace
	forvalues i = 0/6 {
		file write myfile " `row`i''" _n
	}
	file close myfile
	
